/****************************************************************************
 *   $Id:: main.c 6954 2011-03-23 23:02:28Z usb00423                      $
 *   Project: NXP LPC11U6x IAP
 *
 *   Description:
 *     This file contains the In-Application Programming code for LPC 11U6x.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
/* LPC11U6xx definitions */
#include "LPC11U6x.h"
#include "lpc11U6x_clkconfig.h"
#include "IAP.h"
#include"lpc11U6x_gpio.h"
#include "EEPROM.h"
#include <stdio.h>
#include <string.h>

#define TEST_TIMER_NUM		0		/* 0 or 1 for 16-bit timers only */
#define EEPROM_SIZE   		4096 - 64
#define SRC0 0x1FFF2100 // source address if RAM

#define SRC1 0x1FFF2100 // source address if RAM
#define DST1 0x012100		// destination address of flash

extern volatile uint32_t timer16_0_counter[2];
extern volatile uint32_t timer16_1_counter[2];

uint8_t  *ptr = (uint8_t *)0x10003000;
uint8_t eeprom_result_data_array[4096]={0};

void fail(int er);
void pass(void);

void menu(void);
void CopyInterruptToSRAM(void);
void ClearStringBuffer(void);
uint8_t get_key( void );

#define SYSTICK_DELAY		(SystemCoreClock/1000)

#define TEST_INTERRUPT 1

const char ascii[] = "0123456789ABCDEF";
char lineBuff[80], valBuff[80];
uint32_t *bootFirstByte, *bootSecondByte, bootTemp, bootTemp1;

uint8_t rxCallbackBuf[8];

/*********************************************************************//**
 * @brief        Copy the interrupt vector on the Flash to SRAM
 *
 * @param[in]    void
 *
 * @return       void
 *
 **********************************************************************/
void CopyInterruptToSRAM(void)
{
	unsigned int * flashPtr, * ramPtr;
  unsigned int * uLimit = (unsigned int *) 0x200;

		ramPtr = (unsigned int *)0x10000000;	//load RAM starting at 0x10000000,
		flashPtr = (unsigned int *)0x00;			//start of interrupt vector table
	  while(flashPtr < uLimit)
			{
				*ramPtr = *flashPtr;
				ramPtr++;
				flashPtr++;
			}
}

/* Main Program */
int main (void)
{
	uint32_t i,iapTemp;
	uint32_t *part_id;
	uint32_t IAP_result;
  uint32_t pa1, result[5];

  SystemCoreClockUpdate();

  /* GPIO Initialization */
 GPIOInit();
 GPIOSetDir(2,16,1); // Port P2_16 set as output
 GPIOSetDir(2,17,1); // Port P2_17 set as output
 GPIOSetDir(2,18,1); // Port P2_18 set as output

 #if TEST_INTERRUPT
	CopyInterruptToSRAM();		//remap interrupt vector to SRAM
	LPC_SYSCON->SYSMEMREMAP = 0x1;	//change memory map
	//Enable GPIO domain
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);
	//Setup PIO2_5 as GPIO to toggle LED
	LPC_IOCON->PIO2_5 &= ~(3<<3);
	LPC_GPIO_PORT->DIR[2] |= 1<<5;

	/* Called for system library in core_cmx.h(x=0 or 3). */
  SysTick_Config( SYSTICK_DELAY );
	#endif


  //check 32-bit EEPROM program

  for(i = 0; i < EEPROM_SIZE; i++){
			 *(ptr+i) = *(uint8_t *)(0x1FFF1000 + i);
			 eeprom_result_data_array[i] = ~*(ptr+i);
  	  	  }
	IAP_result = u32EEPROM_WRITE(0x0, (uint32_t)ptr, EEPROM_SIZE);


	//check 32-bit EEPROM read

	IAP_result = u32EEPROM_READ(0x0,(uint32_t)eeprom_result_data_array,EEPROM_SIZE);


	/* Part ID */

	part_id = &iapTemp;
	IAP_result = u32IAP_ReadPartID(part_id);


	/* Boot version */

	bootFirstByte = &bootTemp;
	bootSecondByte = &bootTemp1;
	IAP_result = u32IAP_ReadBootVersion(bootFirstByte,bootSecondByte);


	//erase sector 25~28

	IAP_result = u32IAP_PrepareSectors(25, 28);
	IAP_result = u32IAP_EraseSectors(25, 28);

	// Blank check sectors

	IAP_result = u32IAP_BlankCheckSectors(25, 28, result);



	//program 1024 bytes to address 0x012100

	for(i = 0; i < 1024; i++)
		*(ptr+i) = *(uint8_t *)(SRC1 + i);
	IAP_result = u32IAP_PrepareSectors(18, 18);

	IAP_result = u32IAP_CopyRAMToFlash(DST1, (uint32_t)ptr, 1024);

	 for(i = 0; i < 1024; i++)
	     *(ptr+i) = *(uint8_t *)(0x1FFF2100 + i);

	IAP_result = u32IAP_Compare(DST1,(uint32_t)ptr, 1024, &pa1);

	for(i = 0; i < 1024; i++)
	     *(ptr+i) = *(uint8_t *)(0x1FFF2100 + i);
	//check result
	IAP_result = u32IAP_Compare(0x012100, (uint32_t)ptr, 1024, &pa1);

	//page erase
	//page 289

	IAP_result = u32IAP_PrepareSectors(18, 18);
	IAP_result = u32IAP_ErasePage(289, 289);


	while(1)
	{
		if(IAP_result==0)
		{  /*  IAP is successful */
			GPIOSetBitValue(2,16,0); // Green LED is on
			GPIOSetBitValue(2,17,1); // Red LED is off
			GPIOSetBitValue(2,18,1); // Yellow LED is off
		}
		else
		{   /* IAP fails */
			GPIOSetBitValue(2,16,1); // Green LED is off
			GPIOSetBitValue(2,17,0); // Red LED is on
			GPIOSetBitValue(2,18,1); // Yellow LED is off
		}

	}
}
